#!/bin/bash
	
	# Read JSON input from stdin
	json_input=$(cat)
	
	# Extract file_path from JSON using jq or grep/sed
	# Try jq first if available, otherwise use grep/sed
	if command -v jq &> /dev/null; then
	   file_path=$(echo "$json_input" | jq -r '.tool_input.file_path // empty')
	else
	   # Fallback to grep/sed for extracting file_path
	   file_path=$(echo "$json_input" | grep -o '"file_path"[[:space:]]*:[[:space:]]*"[^"]*"' | sed 's/.*"file_path"[[:space:]]*:[[:space:]]*"\([^"]*\)".*/\1/')
	fi
	
	# If no file_path found, allow the operation
	if [ -z "$file_path" ]; then
	   exit 0
	fi
	
	# Check if file exists and contains system-generated marker
	if [ -f "$file_path" ]; then
	   if grep -q "// |@@| C" "$file_path"; then
	       echo "Error: Cannot modify system-generated file (contains // |@@| C marker)." >&2
	       exit 2
	   fi
	fi
	
	exit 0
	