#!/bin/bash

# Build script for devt-claude-runner Docker image with cache optimization
# This script builds the Claude Code runner image with proper cache handling

set -e

IMAGE_NAME="gardening-claude-runner"
TAG="latest"
FULL_IMAGE_NAME="${IMAGE_NAME}:${TAG}"

echo "Building Docker image: ${FULL_IMAGE_NAME}"
echo "Using build cache and targeting 'runner' stage..."

# Build with cache optimization and specific target
docker build \
  --target runner \
  --cache-from "${FULL_IMAGE_NAME}" \
  --tag "${FULL_IMAGE_NAME}" \
  .

echo "✅ Successfully built ${FULL_IMAGE_NAME}"
echo "Image is now available for use without rebuilding"

# Show image details
docker images | grep "${IMAGE_NAME}" | head -1