#!/bin/bash

# Start Claude Code instance
echo "Starting Claude Code runner..."

# Copy the read-only mounted config if it exists
if [ -d /mnt/claude ]; then
    echo "Copying Claude config to writable location..."
    cp -r /mnt/claude /home/claude/.claude
else
    echo "No Claude config found, Claude will create default config"
fi

# Display version for debugging
echo "Claude Code version:"
claude --version || echo "Warning: Could not get Claude Code version"

# Check if a prompt was provided via environment variable
if [ -z "$CLAUDE_PROMPT" ]; then
    echo "Error: CLAUDE_PROMPT environment variable not set"
    exit 1
fi

echo "Executing Claude with prompt: $CLAUDE_PROMPT"
echo "Working directory: $(pwd)"

# Execute Claude with the provided prompt using -p flag and JSON output
claude --dangerously-skip-permissions -p "$CLAUDE_PROMPT" --output-format json > /tmp/claude_output.json
echo "Claude Code runner completed"

cp -r /home/claude/.claude/projects /app/claude-logs
cp /tmp/claude_output.json /app/claude-logs/.