
CREATE TABLE "events" (
"id" UUID PRIMARY KEY DEFAULT gen_random_uuid(),
"created_at" TIMESTAMP,
"updated_at" TIMESTAMP,
"what" TEXT,
"who" TEXT,
"when" TIMESTAMP,
"why" TEXT,
"resource_id" TEXT,
"resource_type" TEXT
);

CREATE TABLE "garden_tasks" (
"id" UUID PRIMARY KEY DEFAULT gen_random_uuid(),
"created_at" TIMESTAMP,
"updated_at" TIMESTAMP,
"description" TEXT,
"name" TEXT,
"start_date" TIMESTAMP,
"garden_id" UUID,
"plantation_id" UUID
);

CREATE TABLE "gardens" (
"id" UUID PRIMARY KEY DEFAULT gen_random_uuid(),
"created_at" TIMESTAMP,
"updated_at" TIMESTAMP,
"name" TEXT,
"picture" TEXT
);

CREATE TABLE "plant_tasks" (
"id" UUID PRIMARY KEY DEFAULT gen_random_uuid(),
"created_at" TIMESTAMP,
"updated_at" TIMESTAMP,
"description" TEXT,
"name" TEXT,
"start_date" TIMESTAMP,
"plant_id" UUID
);

CREATE TABLE "plantations" (
"id" UUID PRIMARY KEY DEFAULT gen_random_uuid(),
"created_at" TIMESTAMP,
"updated_at" TIMESTAMP,
"name" TEXT,
"planted_at" TIMESTAMP,
"plant_id" UUID,
"garden_id" UUID
);

CREATE TABLE "plants" (
"id" UUID PRIMARY KEY DEFAULT gen_random_uuid(),
"created_at" TIMESTAMP,
"updated_at" TIMESTAMP,
"data" JSON,
"description" TEXT,
"exposition" TEXT,
"harvested" NUMERIC,
"name" TEXT,
"perennial" BOOLEAN,
"planting_schema" JSON,
"reference" TEXT,
"size" INTEGER
);

CREATE TABLE "seed_programs" (
"id" UUID PRIMARY KEY DEFAULT gen_random_uuid(),
"created_at" TIMESTAMP,
"updated_at" TIMESTAMP,
"contact" TEXT,
"description" TEXT,
"name" TEXT,
"plant_id" UUID
);

CREATE TABLE "users" (
"id" UUID PRIMARY KEY DEFAULT gen_random_uuid(),
"created_at" TIMESTAMP,
"updated_at" TIMESTAMP,
"name" TEXT
);
