# Quick Start Guide

## 5-Minute Setup

### 1. Environment Setup
```bash
# Set development environment
export ENV=dev

# Start development server
./bin/run/app_web_dev.sh
```

Server starts at `http://localhost:8080`

### 2. Project Structure Overview
```
src/
├── app/           # Application bootstrap and DI
├── mdl/           # Domain models (Garden, User, etc.)
├── mae/           # Business logic (Maestros)
├── srv/           # Services (Fetchers, Handlers, etc.)
└── dat/           # Data structures (Forms, constants)
```

### 3. Understanding the Maestro Pattern
Every business operation follows this pattern:
- **Validate** input data
- **Transform** forms to domain models
- **Execute** business logic
- **Persist** changes to database
- **Return** structured results

This ensures consistent, testable, and maintainable business operations.

## Core Concepts

### Entity Development Workflow
1. **Domain Model** - Define your business entities
2. **Database Mapping** - Create ESO (Entity Storage Object) for SQL compatibility
3. **Service Suite** - Generate Fetchers, Handlers, Hydrators, and other services
4. **Business Logic** - Implement Maestros for complex operations
5. **Web Layer** - Add controllers and routes

### Service Architecture
Each entity gets a complete service suite:
- **Fetcher** - Query and retrieve data
- **Handler** - Create, update, delete operations
- **Hydrator** - Load related entities efficiently
- **Molder** - Transform forms to domain models
- **Serializer** - Convert to JSON responses

### Request Flow
1. **Route** receives HTTP request
2. **Controller** processes request and calls Mae
3. **Mae** orchestrates business logic using services
4. **Services** handle database operations
5. **Controller** returns formatted response

## Development Workflow

### Creating New Features
1. Start with domain modeling
2. Create database schema
3. Generate service implementations
4. Add business logic with Maestros
5. Implement controllers and routes
6. Write functional tests

### Working with Data
- Use **Fetchers** for complex queries with filtering and pagination
- Use **Handlers** for CRUD operations with transaction support
- Use **Hydrators** to load relationships without N+1 queries
- Use **Preset patterns** for consistent data loading across contexts

## Testing Approach

### Test Types
- **Unit Tests** - Individual service testing
- **Functional Tests** - Maestro business logic testing
- **Integration Tests** - End-to-end workflow testing

### Running Tests
```bash
# Test specific functionality
go test ./tests/functional/maes/

# Run all tests with coverage
./bin/tests/check.sh
```

## Next Steps

Continue your learning journey:

1. **[First Application](first-application.md)** - Complete step-by-step tutorial
2. **[The Basics](../the-basics/)** - Core concepts and patterns
3. **[Architecture](../architecture/)** - Framework design principles
4. **[Services](../services/)** - Detailed service documentation