# Common Patterns

## Entity Creation Pattern

The framework follows a consistent pattern for creating new entities:

### Flow: Form → Validation → Transformation → Persistence

1. **Form Binding** - HTTP request data bound to structured forms
2. **Validation** - Input validation with clear error messages
3. **Transformation** - Forms converted to domain models via Molders
4. **Business Logic** - Maestros orchestrate the creation process
5. **Persistence** - Handlers save to database with transactions

This pattern ensures data integrity and consistent error handling across all entity creation operations.

## Service Integration Pattern

### Maestro Orchestration

Maestros coordinate multiple services to complete business operations:

- **Validators** ensure data meets business rules
- **Molders** transform input forms to domain models
- **Handlers** manage database operations
- **Hydrators** load related data when needed
- **Serializers** format responses

Each step is explicit and testable, making complex operations maintainable.

## Query and Response Pattern

### Three-Step Process: Fetch → Hydrate → Serialize

1. **Fetch** - Retrieve entities with filtering and pagination
2. **Hydrate** - Load relationships using preset patterns
3. **Serialize** - Convert to JSON with appropriate field selection

This separation allows for:
- **Performance optimization** through selective loading
- **Security** by controlling exposed data
- **Flexibility** in response formats

## Form Handling Pattern

### Change Detection and Optimization

The framework tracks form changes to optimize database updates:

- **Molders** compare form values with existing entities
- **Change lists** identify modified fields
- **Selective updates** only modify changed columns
- **Audit trails** can track what changed and when

This pattern reduces database load and provides clear change history.

## Error Handling Pattern

The framework provides comprehensive error handling across all layers. For detailed information on error types, response patterns, and implementation strategies, see **[Error Handling](error-handling.md)**.

## Testing Patterns

### Three Levels of Testing

1. **Unit Tests** - Individual service testing
   - Test Fetchers, Handlers, Validators in isolation
   - Mock dependencies for focused testing

2. **Functional Tests** - Maestro operation testing
   - Test complete business workflows
   - Verify data transformations and persistence

3. **Integration Tests** - End-to-end testing
   - Test HTTP endpoints and full request cycles
   - Verify database operations and response formats

## Database Patterns

### Query Building

Fetchers provide a fluent interface for building queries:

- **Filters** - Exact matches, contains, ranges, null checks
- **Ordering** - Single or multiple column sorting
- **Pagination** - Limit and offset with count totals
- **Scoping** - Reusable query conditions

### Relationship Loading

Hydrators manage entity relationships:

- **Preset Patterns** - Predefined relationship sets for different contexts
- **Batch Loading** - Prevent N+1 queries through efficient batching
- **Selective Loading** - Only load needed relationships
- **Deep Loading** - Navigate multi-level relationships

## Performance Patterns

The framework includes several built-in performance optimizations like batch operations, change detection, and preset hydration patterns. For comprehensive performance optimization strategies, caching implementations, and monitoring techniques, see **[Performance Optimization](../advanced/performance.md)** and **[Caching Strategies](../advanced/caching.md)**.

## Security Patterns

The framework implements multiple security layers including input validation, SQL injection prevention, and access control. For comprehensive security implementation including authentication, authorization, rate limiting, and security headers, see **[Security Implementation](../advanced/security.md)**.

These patterns form the foundation of the framework's architecture, promoting consistency, maintainability, and reliability across all applications built with it.