# Frontend

## Overview

The framework uses Tailwind CSS for styling with server-side HTML rendering and optional JavaScript enhancements.

## Tailwind CSS Setup

### Installation
```bash
npm install
```

### CSS Compilation
```bash
# Development with watch
npx tailwindcss -i input.css -o ./assets/css/output.css --watch

# Production build
npx tailwindcss -i input.css -o ./assets/css/output.css --minify
```

## Basic HTML Structure

### Template Layout
```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{.title}}</title>
    <link href="/assets/css/output.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
    <div class="min-h-screen">
        {{template "navbar.html"}}
        
        <main class="container mx-auto px-4 py-8">
            {{.content}}
        </main>
    </div>
</body>
</html>
```

### Component Styling
```html
<!-- Cards -->
<div class="bg-white rounded-lg shadow-md p-6">
    <h2 class="text-xl font-semibold mb-4">{{.title}}</h2>
    <p class="text-gray-600">{{.content}}</p>
</div>

<!-- Buttons -->
<button class="bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded transition-colors">
    Save Changes
</button>

<!-- Forms -->
<input class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" 
       type="text" name="name">
```

## JavaScript Integration

### Basic Interactivity
```html
<script>
function confirmDelete(name) {
    return confirm(`Delete ${name}?`);
}
</script>

<button onclick="return confirmDelete('{{.garden.Name}}')" 
        class="text-red-600 hover:text-red-800">
    Delete
</button>
```

### HTMX for Dynamic Content
```html
<div hx-get="/gardens/{{.Id}}/plants" 
     hx-trigger="click"
     hx-target="#plant-list">
    Load Plants
</div>
<div id="plant-list"></div>
```

## Responsive Design

### Mobile-First Approach
```html
<!-- Responsive grid -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    {{range .items}}
    <div class="bg-white rounded-lg p-4">
        {{.content}}
    </div>
    {{end}}
</div>

<!-- Responsive navigation -->
<nav class="hidden md:block">
    <!-- Desktop menu -->
</nav>
<div class="md:hidden">
    <!-- Mobile menu -->
</div>
```