package main

import (
	"context"
	"gardening/src/app"
	"os"
	"runtime/debug"
)

func main() {
	defer func() {
		if r := recover(); r != nil {
			println("\n------\n[E] Recovered in main\n")
			err, ok := r.(error)
			if ok {
				println(err.Error())
			}
			println(string(debug.Stack()))
			os.Exit(1)
		}
	}()

	ctx := context.Background()
	a := app.App{}
	a.Build(ctx, os.Getenv("ENV"))
	a.Run(ctx, os.Args)
}
