package container

// |@@| C

import (
	"gardening/src/app/routers"
	ajx_routes "gardening/src/app/routing/ajx_routes"
	api_routes "gardening/src/app/routing/api_routes"
	app_routes "gardening/src/app/routing/app_routes"
	misc_routes "gardening/src/app/routing/misc_routes"
	"gardening/src/app/setup"
	"gardening/src/lib/binder"
	"gardening/src/lib/config"
	"gardening/src/lib/contexter"
	"gardening/src/lib/cookier"
	"gardening/src/lib/dev_tool"
	"gardening/src/lib/dotor"
	"gardening/src/lib/exec"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/filesystem"
	"gardening/src/lib/handler"
	"gardening/src/lib/hydrator"
	"gardening/src/lib/jsoner"
	"gardening/src/lib/kit"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/middlewares"
	"gardening/src/lib/op"
	"gardening/src/lib/operating_system"
	"gardening/src/lib/presenter"
	"gardening/src/lib/relationer"
	"gardening/src/lib/route"
	"gardening/src/lib/router"
	"gardening/src/lib/searcher"
	"gardening/src/lib/special_views"
	"gardening/src/lib/spy"
	"gardening/src/lib/sql"
	"gardening/src/lib/sql_db"
	"gardening/src/lib/string_converter"
	"gardening/src/lib/struct_differ"
	"gardening/src/lib/time"
	"gardening/src/lib/uploader"
	"gardening/src/lib/uuider"
	"gardening/src/lib/validator"
	"gardening/src/lib/web_server"
	"gardening/src/mae"
	"gardening/src/srv/autocompleters"
	"gardening/src/srv/binders"
	"gardening/src/srv/commands"
	"gardening/src/srv/companions"
	"gardening/src/srv/completers"
	"gardening/src/srv/entity_policies"
	"gardening/src/srv/entity_validators"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/html_views"
	"gardening/src/srv/hydrators"
	"gardening/src/srv/importers"
	"gardening/src/srv/json_views"
	"gardening/src/srv/layout_config"
	"gardening/src/srv/layouts"
	"gardening/src/srv/menus"
	"gardening/src/srv/molders"
	"gardening/src/srv/presenters"
	"gardening/src/srv/relationers"
	"gardening/src/srv/searchers"
	"gardening/src/srv/serializers"
	"gardening/src/srv/show_presenters"
	"gardening/src/srv/stringers"
	"gardening/src/srv/tables"
	"gardening/src/srv/urlers"
)

type Container struct {
	AjxRouter                         *routers.AjxRouter
	ApiRoute                          *route.ApiRoute
	ApiRouter                         *routers.ApiRouter
	AppLoginMiscRoute                 *misc_routes.AppLoginMiscRoute
	AppRoute                          *route.AppRoute
	AppRouter                         *routers.AppRouter
	AppUrler                          *urlers.AppUrler
	AuthRouter                        *routers.AuthRouter
	AutocompleteAjxRoute              *ajx_routes.AutocompleteAjxRoute
	Autocompleter                     *autocompleters.Autocompleter
	AutologinMiddleware               *middlewares.AutologinMiddleware
	Binder                            *binder.Binder
	Config                            *config.Config
	Contexter                         *contexter.Contexter
	Cookier                           *cookier.Cookier
	CreateGardenApiRoute              *api_routes.CreateGardenApiRoute
	CreateGardenAppBinder             *binders.CreateGardenAppBinder
	CreateGardenAppRoute              *app_routes.CreateGardenAppRoute
	CreateGardenFormMolder            *molders.CreateGardenFormMolder
	CreateGardenFormPresenter         *form_presenters.CreateGardenFormPresenter
	CreateGardenFormValidator         *form_validators.CreateGardenFormValidator
	CreateGardenJsonView              *json_views.CreateGardenJsonView
	CreateGardenMae                   *mae.CreateGardenMae
	CreateGardenTaskApiRoute          *api_routes.CreateGardenTaskApiRoute
	CreateGardenTaskAppBinder         *binders.CreateGardenTaskAppBinder
	CreateGardenTaskAppRoute          *app_routes.CreateGardenTaskAppRoute
	CreateGardenTaskFormMolder        *molders.CreateGardenTaskFormMolder
	CreateGardenTaskFormPresenter     *form_presenters.CreateGardenTaskFormPresenter
	CreateGardenTaskFormValidator     *form_validators.CreateGardenTaskFormValidator
	CreateGardenTaskJsonView          *json_views.CreateGardenTaskJsonView
	CreateGardenTaskMae               *mae.CreateGardenTaskMae
	CreatePlantApiRoute               *api_routes.CreatePlantApiRoute
	CreatePlantAppBinder              *binders.CreatePlantAppBinder
	CreatePlantAppRoute               *app_routes.CreatePlantAppRoute
	CreatePlantFormMolder             *molders.CreatePlantFormMolder
	CreatePlantFormPresenter          *form_presenters.CreatePlantFormPresenter
	CreatePlantFormValidator          *form_validators.CreatePlantFormValidator
	CreatePlantJsonView               *json_views.CreatePlantJsonView
	CreatePlantMae                    *mae.CreatePlantMae
	CreatePlantTaskApiRoute           *api_routes.CreatePlantTaskApiRoute
	CreatePlantTaskAppBinder          *binders.CreatePlantTaskAppBinder
	CreatePlantTaskAppRoute           *app_routes.CreatePlantTaskAppRoute
	CreatePlantTaskFormMolder         *molders.CreatePlantTaskFormMolder
	CreatePlantTaskFormPresenter      *form_presenters.CreatePlantTaskFormPresenter
	CreatePlantTaskFormValidator      *form_validators.CreatePlantTaskFormValidator
	CreatePlantTaskJsonView           *json_views.CreatePlantTaskJsonView
	CreatePlantTaskMae                *mae.CreatePlantTaskMae
	CreatePlantationApiRoute          *api_routes.CreatePlantationApiRoute
	CreatePlantationAppBinder         *binders.CreatePlantationAppBinder
	CreatePlantationAppRoute          *app_routes.CreatePlantationAppRoute
	CreatePlantationFormMolder        *molders.CreatePlantationFormMolder
	CreatePlantationFormPresenter     *form_presenters.CreatePlantationFormPresenter
	CreatePlantationFormValidator     *form_validators.CreatePlantationFormValidator
	CreatePlantationJsonView          *json_views.CreatePlantationJsonView
	CreatePlantationMae               *mae.CreatePlantationMae
	CreateSeedProgramApiRoute         *api_routes.CreateSeedProgramApiRoute
	CreateSeedProgramAppBinder        *binders.CreateSeedProgramAppBinder
	CreateSeedProgramAppRoute         *app_routes.CreateSeedProgramAppRoute
	CreateSeedProgramFormMolder       *molders.CreateSeedProgramFormMolder
	CreateSeedProgramFormPresenter    *form_presenters.CreateSeedProgramFormPresenter
	CreateSeedProgramFormValidator    *form_validators.CreateSeedProgramFormValidator
	CreateSeedProgramJsonView         *json_views.CreateSeedProgramJsonView
	CreateSeedProgramMae              *mae.CreateSeedProgramMae
	CreateUserApiRoute                *api_routes.CreateUserApiRoute
	CreateUserAppBinder               *binders.CreateUserAppBinder
	CreateUserAppRoute                *app_routes.CreateUserAppRoute
	CreateUserFormMolder              *molders.CreateUserFormMolder
	CreateUserFormPresenter           *form_presenters.CreateUserFormPresenter
	CreateUserFormValidator           *form_validators.CreateUserFormValidator
	CreateUserJsonView                *json_views.CreateUserJsonView
	CreateUserMae                     *mae.CreateUserMae
	DeleteGardenAppRoute              *app_routes.DeleteGardenAppRoute
	DeleteGardenMae                   *mae.DeleteGardenMae
	DeleteGardenTaskAppRoute          *app_routes.DeleteGardenTaskAppRoute
	DeleteGardenTaskMae               *mae.DeleteGardenTaskMae
	DeletePlantAppRoute               *app_routes.DeletePlantAppRoute
	DeletePlantMae                    *mae.DeletePlantMae
	DeletePlantTaskAppRoute           *app_routes.DeletePlantTaskAppRoute
	DeletePlantTaskMae                *mae.DeletePlantTaskMae
	DeletePlantationAppRoute          *app_routes.DeletePlantationAppRoute
	DeletePlantationMae               *mae.DeletePlantationMae
	DeleteSeedProgramAppRoute         *app_routes.DeleteSeedProgramAppRoute
	DeleteSeedProgramMae              *mae.DeleteSeedProgramMae
	DeleteUserAppRoute                *app_routes.DeleteUserAppRoute
	DeleteUserMae                     *mae.DeleteUserMae
	DevTool                           *dev_tool.DevTool
	DevtMiddleware                    *middlewares.DevtMiddleware
	DisplayOpMiscRoute                *misc_routes.DisplayOpMiscRoute
	DisplayWeatherForecastAppBinder   *binders.DisplayWeatherForecastAppBinder
	DisplayWeatherForecastAppRoute    *app_routes.DisplayWeatherForecastAppRoute
	DisplayWeatherForecastMae         *mae.DisplayWeatherForecastMae
	DisplayWeatherForecastView        *html_views.DisplayWeatherForecastView
	Dotor                             *dotor.Dotor
	EditGardenAppBinder               *binders.EditGardenAppBinder
	EditGardenAppRoute                *app_routes.EditGardenAppRoute
	EditGardenMae                     *mae.EditGardenMae
	EditGardenTaskAppBinder           *binders.EditGardenTaskAppBinder
	EditGardenTaskAppRoute            *app_routes.EditGardenTaskAppRoute
	EditGardenTaskMae                 *mae.EditGardenTaskMae
	EditGardenTaskView                *html_views.EditGardenTaskView
	EditGardenView                    *html_views.EditGardenView
	EditPlantAppBinder                *binders.EditPlantAppBinder
	EditPlantAppRoute                 *app_routes.EditPlantAppRoute
	EditPlantMae                      *mae.EditPlantMae
	EditPlantTaskAppBinder            *binders.EditPlantTaskAppBinder
	EditPlantTaskAppRoute             *app_routes.EditPlantTaskAppRoute
	EditPlantTaskMae                  *mae.EditPlantTaskMae
	EditPlantTaskView                 *html_views.EditPlantTaskView
	EditPlantView                     *html_views.EditPlantView
	EditPlantationAppBinder           *binders.EditPlantationAppBinder
	EditPlantationAppRoute            *app_routes.EditPlantationAppRoute
	EditPlantationMae                 *mae.EditPlantationMae
	EditPlantationView                *html_views.EditPlantationView
	EditSeedProgramAppBinder          *binders.EditSeedProgramAppBinder
	EditSeedProgramAppRoute           *app_routes.EditSeedProgramAppRoute
	EditSeedProgramMae                *mae.EditSeedProgramMae
	EditSeedProgramView               *html_views.EditSeedProgramView
	EditUserAppBinder                 *binders.EditUserAppBinder
	EditUserAppRoute                  *app_routes.EditUserAppRoute
	EditUserMae                       *mae.EditUserMae
	EditUserView                      *html_views.EditUserView
	EmptyLayout                       *layouts.EmptyLayout
	ErrorView                         *special_views.ErrorView
	EventCompanion                    *companions.EventCompanion
	EventEntityPolicy                 *entity_policies.EventEntityPolicy
	EventEntityValidator              *entity_validators.EventEntityValidator
	EventFetcher                      *fetchers.EventFetcher
	EventHandler                      *handlers.EventHandler
	EventHydrator                     *hydrators.EventHydrator
	EventRelationer                   *relationers.EventRelationer
	EventSerializer                   *serializers.EventSerializer
	EventStringer                     *stringers.EventStringer
	EventTable                        *tables.EventTable
	ExchangeRouter                    *routers.ExchangeRouter
	ExecInterface                     exec.ExecInterface
	ExecIpl                           *exec.ExecIpl
	Fetcher                           *fetcher.Fetcher
	Fetchers                          *fetchers.Fetchers
	FilesUploader                     *uploader.FilesUploader
	Filesystem                        *filesystem.Filesystem
	FollowOpMiscRoute                 *misc_routes.FollowOpMiscRoute
	GardenCompanion                   *companions.GardenCompanion
	GardenCompleter                   *completers.GardenCompleter
	GardenEntityPolicy                *entity_policies.GardenEntityPolicy
	GardenEntityValidator             *entity_validators.GardenEntityValidator
	GardenFetcher                     *fetchers.GardenFetcher
	GardenHandler                     *handlers.GardenHandler
	GardenHydrator                    *hydrators.GardenHydrator
	GardenPresenter                   *presenters.GardenPresenter
	GardenRelationer                  *relationers.GardenRelationer
	GardenSearcher                    *searchers.GardenSearcher
	GardenSerializer                  *serializers.GardenSerializer
	GardenShowPresenter               *show_presenters.GardenShowPresenter
	GardenStringer                    *stringers.GardenStringer
	GardenTable                       *tables.GardenTable
	GardenTaskCompanion               *companions.GardenTaskCompanion
	GardenTaskCompleter               *completers.GardenTaskCompleter
	GardenTaskEntityPolicy            *entity_policies.GardenTaskEntityPolicy
	GardenTaskEntityValidator         *entity_validators.GardenTaskEntityValidator
	GardenTaskFetcher                 *fetchers.GardenTaskFetcher
	GardenTaskHandler                 *handlers.GardenTaskHandler
	GardenTaskHydrator                *hydrators.GardenTaskHydrator
	GardenTaskPresenter               *presenters.GardenTaskPresenter
	GardenTaskRelationer              *relationers.GardenTaskRelationer
	GardenTaskSearcher                *searchers.GardenTaskSearcher
	GardenTaskSerializer              *serializers.GardenTaskSerializer
	GardenTaskShowPresenter           *show_presenters.GardenTaskShowPresenter
	GardenTaskStringer                *stringers.GardenTaskStringer
	GardenTaskTable                   *tables.GardenTaskTable
	GinRouter                         *setup.GinRouter
	Handler                           *handler.Handler
	Handlers                          *handlers.Handlers
	HomeAppBinder                     *binders.HomeAppBinder
	HomeAppRoute                      *app_routes.HomeAppRoute
	HomeMae                           *mae.HomeMae
	HomeView                          *html_views.HomeView
	Hydrator                          *hydrator.Hydrator
	InstructPlannerAppBinder          *binders.InstructPlannerAppBinder
	InstructPlannerAppRoute           *app_routes.InstructPlannerAppRoute
	InstructPlannerFormPresenter      *form_presenters.InstructPlannerFormPresenter
	InstructPlannerFormValidator      *form_validators.InstructPlannerFormValidator
	InstructPlannerMae                *mae.InstructPlannerMae
	Jsoner                            *jsoner.Jsoner
	JwtMiddleware                     *middlewares.JwtMiddleware
	Kit                               *kit.Kit
	Layout                            *layouts.Layout
	LayoutConfig                      *layout_config.LayoutConfig
	ListGardenTasksApiRoute           *api_routes.ListGardenTasksApiRoute
	ListGardenTasksAppBinder          *binders.ListGardenTasksAppBinder
	ListGardenTasksAppRoute           *app_routes.ListGardenTasksAppRoute
	ListGardenTasksJsonView           *json_views.ListGardenTasksJsonView
	ListGardenTasksMae                *mae.ListGardenTasksMae
	ListGardenTasksView               *html_views.ListGardenTasksView
	ListGardensApiRoute               *api_routes.ListGardensApiRoute
	ListGardensAppBinder              *binders.ListGardensAppBinder
	ListGardensAppRoute               *app_routes.ListGardensAppRoute
	ListGardensJsonView               *json_views.ListGardensJsonView
	ListGardensMae                    *mae.ListGardensMae
	ListGardensView                   *html_views.ListGardensView
	ListPlantTasksApiRoute            *api_routes.ListPlantTasksApiRoute
	ListPlantTasksAppBinder           *binders.ListPlantTasksAppBinder
	ListPlantTasksAppRoute            *app_routes.ListPlantTasksAppRoute
	ListPlantTasksJsonView            *json_views.ListPlantTasksJsonView
	ListPlantTasksMae                 *mae.ListPlantTasksMae
	ListPlantTasksView                *html_views.ListPlantTasksView
	ListPlantationsApiRoute           *api_routes.ListPlantationsApiRoute
	ListPlantationsAppBinder          *binders.ListPlantationsAppBinder
	ListPlantationsAppRoute           *app_routes.ListPlantationsAppRoute
	ListPlantationsJsonView           *json_views.ListPlantationsJsonView
	ListPlantationsMae                *mae.ListPlantationsMae
	ListPlantationsView               *html_views.ListPlantationsView
	ListPlantsApiRoute                *api_routes.ListPlantsApiRoute
	ListPlantsAppBinder               *binders.ListPlantsAppBinder
	ListPlantsAppRoute                *app_routes.ListPlantsAppRoute
	ListPlantsJsonView                *json_views.ListPlantsJsonView
	ListPlantsMae                     *mae.ListPlantsMae
	ListPlantsView                    *html_views.ListPlantsView
	ListSeedProgramsApiRoute          *api_routes.ListSeedProgramsApiRoute
	ListSeedProgramsAppBinder         *binders.ListSeedProgramsAppBinder
	ListSeedProgramsAppRoute          *app_routes.ListSeedProgramsAppRoute
	ListSeedProgramsJsonView          *json_views.ListSeedProgramsJsonView
	ListSeedProgramsMae               *mae.ListSeedProgramsMae
	ListSeedProgramsView              *html_views.ListSeedProgramsView
	ListUsersApiRoute                 *api_routes.ListUsersApiRoute
	ListUsersAppBinder                *binders.ListUsersAppBinder
	ListUsersAppRoute                 *app_routes.ListUsersAppRoute
	ListUsersJsonView                 *json_views.ListUsersJsonView
	ListUsersMae                      *mae.ListUsersMae
	ListUsersView                     *html_views.ListUsersView
	LoadDictionaryCommand             *commands.LoadDictionaryCommand
	Logger                            *logger.Logger
	MaeMiddleware                     *router.MaeMiddleware
	Maestro                           *maestro.Maestro
	MiscRouter                        *routers.MiscRouter
	MockSqlIpl                        *sql.MockSqlIpl
	NewGardenAppBinder                *binders.NewGardenAppBinder
	NewGardenAppRoute                 *app_routes.NewGardenAppRoute
	NewGardenMae                      *mae.NewGardenMae
	NewGardenTaskAppBinder            *binders.NewGardenTaskAppBinder
	NewGardenTaskAppRoute             *app_routes.NewGardenTaskAppRoute
	NewGardenTaskMae                  *mae.NewGardenTaskMae
	NewGardenTaskView                 *html_views.NewGardenTaskView
	NewGardenView                     *html_views.NewGardenView
	NewPlantAppBinder                 *binders.NewPlantAppBinder
	NewPlantAppRoute                  *app_routes.NewPlantAppRoute
	NewPlantMae                       *mae.NewPlantMae
	NewPlantTaskAppBinder             *binders.NewPlantTaskAppBinder
	NewPlantTaskAppRoute              *app_routes.NewPlantTaskAppRoute
	NewPlantTaskMae                   *mae.NewPlantTaskMae
	NewPlantTaskView                  *html_views.NewPlantTaskView
	NewPlantView                      *html_views.NewPlantView
	NewPlantationAppBinder            *binders.NewPlantationAppBinder
	NewPlantationAppRoute             *app_routes.NewPlantationAppRoute
	NewPlantationMae                  *mae.NewPlantationMae
	NewPlantationView                 *html_views.NewPlantationView
	NewSeedProgramAppBinder           *binders.NewSeedProgramAppBinder
	NewSeedProgramAppRoute            *app_routes.NewSeedProgramAppRoute
	NewSeedProgramMae                 *mae.NewSeedProgramMae
	NewSeedProgramView                *html_views.NewSeedProgramView
	NewUserAppBinder                  *binders.NewUserAppBinder
	NewUserAppRoute                   *app_routes.NewUserAppRoute
	NewUserMae                        *mae.NewUserMae
	NewUserView                       *html_views.NewUserView
	OpStore                           *op.OpStore
	OpenFileMiscRoute                 *misc_routes.OpenFileMiscRoute
	OpenapiMiscRoute                  *misc_routes.OpenapiMiscRoute
	OperatingSystemInterface          operating_system.OperatingSystemInterface
	OperatingSystemIpl                *operating_system.OperatingSystemIpl
	OverviewStorageAppBinder          *binders.OverviewStorageAppBinder
	OverviewStorageAppRoute           *app_routes.OverviewStorageAppRoute
	OverviewStorageMae                *mae.OverviewStorageMae
	OverviewStorageView               *html_views.OverviewStorageView
	PerformAnalyseAppBinder           *binders.PerformAnalyseAppBinder
	PerformAnalyseAppRoute            *app_routes.PerformAnalyseAppRoute
	PerformAnalyseFormPresenter       *form_presenters.PerformAnalyseFormPresenter
	PerformAnalyseFormValidator       *form_validators.PerformAnalyseFormValidator
	PerformAnalyseMae                 *mae.PerformAnalyseMae
	PerformEventsFormPresenter        *form_presenters.PerformEventsFormPresenter
	PerformEventsFormValidator        *form_validators.PerformEventsFormValidator
	PerformImagesRoutineAppBinder     *binders.PerformImagesRoutineAppBinder
	PerformImagesRoutineAppRoute      *app_routes.PerformImagesRoutineAppRoute
	PerformImagesRoutineFormPresenter *form_presenters.PerformImagesRoutineFormPresenter
	PerformImagesRoutineFormValidator *form_validators.PerformImagesRoutineFormValidator
	PerformImagesRoutineMae           *mae.PerformImagesRoutineMae
	PerformPlannerFormPresenter       *form_presenters.PerformPlannerFormPresenter
	PerformPlannerFormValidator       *form_validators.PerformPlannerFormValidator
	PerformRenewOrdersAppBinder       *binders.PerformRenewOrdersAppBinder
	PerformRenewOrdersAppRoute        *app_routes.PerformRenewOrdersAppRoute
	PerformRenewOrdersFormPresenter   *form_presenters.PerformRenewOrdersFormPresenter
	PerformRenewOrdersFormValidator   *form_validators.PerformRenewOrdersFormValidator
	PerformRenewOrdersMae             *mae.PerformRenewOrdersMae
	PgSqlIpl                          *sql.PgSqlIpl
	PingMiscRoute                     *misc_routes.PingMiscRoute
	PlantCompanion                    *companions.PlantCompanion
	PlantCompleter                    *completers.PlantCompleter
	PlantEntityPolicy                 *entity_policies.PlantEntityPolicy
	PlantEntityValidator              *entity_validators.PlantEntityValidator
	PlantFetcher                      *fetchers.PlantFetcher
	PlantHandler                      *handlers.PlantHandler
	PlantHydrator                     *hydrators.PlantHydrator
	PlantImporter                     *importers.PlantImporter
	PlantPresenter                    *presenters.PlantPresenter
	PlantRelationer                   *relationers.PlantRelationer
	PlantSearcher                     *searchers.PlantSearcher
	PlantSerializer                   *serializers.PlantSerializer
	PlantShowPresenter                *show_presenters.PlantShowPresenter
	PlantStringer                     *stringers.PlantStringer
	PlantTable                        *tables.PlantTable
	PlantTaskCompanion                *companions.PlantTaskCompanion
	PlantTaskCompleter                *completers.PlantTaskCompleter
	PlantTaskEntityPolicy             *entity_policies.PlantTaskEntityPolicy
	PlantTaskEntityValidator          *entity_validators.PlantTaskEntityValidator
	PlantTaskFetcher                  *fetchers.PlantTaskFetcher
	PlantTaskHandler                  *handlers.PlantTaskHandler
	PlantTaskHydrator                 *hydrators.PlantTaskHydrator
	PlantTaskPresenter                *presenters.PlantTaskPresenter
	PlantTaskRelationer               *relationers.PlantTaskRelationer
	PlantTaskSearcher                 *searchers.PlantTaskSearcher
	PlantTaskSerializer               *serializers.PlantTaskSerializer
	PlantTaskShowPresenter            *show_presenters.PlantTaskShowPresenter
	PlantTaskStringer                 *stringers.PlantTaskStringer
	PlantTaskTable                    *tables.PlantTaskTable
	PlantationCompanion               *companions.PlantationCompanion
	PlantationCompleter               *completers.PlantationCompleter
	PlantationEntityPolicy            *entity_policies.PlantationEntityPolicy
	PlantationEntityValidator         *entity_validators.PlantationEntityValidator
	PlantationFetcher                 *fetchers.PlantationFetcher
	PlantationHandler                 *handlers.PlantationHandler
	PlantationHydrator                *hydrators.PlantationHydrator
	PlantationPresenter               *presenters.PlantationPresenter
	PlantationRelationer              *relationers.PlantationRelationer
	PlantationSearcher                *searchers.PlantationSearcher
	PlantationSerializer              *serializers.PlantationSerializer
	PlantationShowPresenter           *show_presenters.PlantationShowPresenter
	PlantationStringer                *stringers.PlantationStringer
	PlantationTable                   *tables.PlantationTable
	Presenter                         *presenter.Presenter
	Presenters                        *presenters.Presenters
	RecoveryMiddleware                *middlewares.RecoveryMiddleware
	Relationer                        *relationer.Relationer
	RootMiscRoute                     *misc_routes.RootMiscRoute
	Router                            *router.Router
	SearchAjxRoute                    *ajx_routes.SearchAjxRoute
	Searcher                          *searcher.Searcher
	Searchers                         *searchers.Searchers
	SecondarySql                      sql.SecondarySql
	SeeEventsAppBinder                *binders.SeeEventsAppBinder
	SeeEventsAppRoute                 *app_routes.SeeEventsAppRoute
	SeeEventsMae                      *mae.SeeEventsMae
	SeeEventsView                     *html_views.SeeEventsView
	SeePlannerAppBinder               *binders.SeePlannerAppBinder
	SeePlannerAppRoute                *app_routes.SeePlannerAppRoute
	SeePlannerMae                     *mae.SeePlannerMae
	SeePlannerView                    *html_views.SeePlannerView
	SeeRenewOrdersAppBinder           *binders.SeeRenewOrdersAppBinder
	SeeRenewOrdersAppRoute            *app_routes.SeeRenewOrdersAppRoute
	SeeRenewOrdersMae                 *mae.SeeRenewOrdersMae
	SeeRenewOrdersView                *html_views.SeeRenewOrdersView
	SeedProgramCompanion              *companions.SeedProgramCompanion
	SeedProgramCompleter              *completers.SeedProgramCompleter
	SeedProgramEntityPolicy           *entity_policies.SeedProgramEntityPolicy
	SeedProgramEntityValidator        *entity_validators.SeedProgramEntityValidator
	SeedProgramFetcher                *fetchers.SeedProgramFetcher
	SeedProgramHandler                *handlers.SeedProgramHandler
	SeedProgramHydrator               *hydrators.SeedProgramHydrator
	SeedProgramPresenter              *presenters.SeedProgramPresenter
	SeedProgramRelationer             *relationers.SeedProgramRelationer
	SeedProgramSearcher               *searchers.SeedProgramSearcher
	SeedProgramSerializer             *serializers.SeedProgramSerializer
	SeedProgramShowPresenter          *show_presenters.SeedProgramShowPresenter
	SeedProgramStringer               *stringers.SeedProgramStringer
	SeedProgramTable                  *tables.SeedProgramTable
	SessionMiddleware                 *middlewares.SessionMiddleware
	SettingsLayout                    *layouts.SettingsLayout
	SettingsMenu                      *menus.SettingsMenu
	ShowGardenAppRoute                *app_routes.ShowGardenAppRoute
	ShowGardenMae                     *mae.ShowGardenMae
	ShowGardenTaskAppRoute            *app_routes.ShowGardenTaskAppRoute
	ShowGardenTaskMae                 *mae.ShowGardenTaskMae
	ShowGardenTaskView                *html_views.ShowGardenTaskView
	ShowGardenView                    *html_views.ShowGardenView
	ShowPlantAppRoute                 *app_routes.ShowPlantAppRoute
	ShowPlantMae                      *mae.ShowPlantMae
	ShowPlantTaskAppRoute             *app_routes.ShowPlantTaskAppRoute
	ShowPlantTaskMae                  *mae.ShowPlantTaskMae
	ShowPlantTaskView                 *html_views.ShowPlantTaskView
	ShowPlantView                     *html_views.ShowPlantView
	ShowPlantationAppRoute            *app_routes.ShowPlantationAppRoute
	ShowPlantationMae                 *mae.ShowPlantationMae
	ShowPlantationView                *html_views.ShowPlantationView
	ShowSeedProgramAppRoute           *app_routes.ShowSeedProgramAppRoute
	ShowSeedProgramMae                *mae.ShowSeedProgramMae
	ShowSeedProgramView               *html_views.ShowSeedProgramView
	ShowUserAppRoute                  *app_routes.ShowUserAppRoute
	ShowUserMae                       *mae.ShowUserMae
	ShowUserView                      *html_views.ShowUserView
	Spy                               *spy.Spy
	Sql                               sql.Sql
	SqlDb                             *sql_db.SqlDb
	SqliteFsSqlIpl                    *sql.SqliteFsSqlIpl
	SqliteMemorySqlIpl                *sql.SqliteMemorySqlIpl
	StringConverter                   *string_converter.StringConverter
	Stringers                         *stringers.Stringers
	StructDiffer                      *struct_differ.StructDiffer
	StructuredLayout                  *layouts.StructuredLayout
	TiledLayout                       *layouts.TiledLayout
	Time                              time.Time
	TimeIpl                           *time.TimeIpl
	TopMenu                           *menus.TopMenu
	UidMiddleware                     *middlewares.UidMiddleware
	UpdateGardenApiRoute              *api_routes.UpdateGardenApiRoute
	UpdateGardenAppBinder             *binders.UpdateGardenAppBinder
	UpdateGardenAppRoute              *app_routes.UpdateGardenAppRoute
	UpdateGardenFormMolder            *molders.UpdateGardenFormMolder
	UpdateGardenFormPresenter         *form_presenters.UpdateGardenFormPresenter
	UpdateGardenFormValidator         *form_validators.UpdateGardenFormValidator
	UpdateGardenJsonView              *json_views.UpdateGardenJsonView
	UpdateGardenMae                   *mae.UpdateGardenMae
	UpdateGardenTaskApiRoute          *api_routes.UpdateGardenTaskApiRoute
	UpdateGardenTaskAppBinder         *binders.UpdateGardenTaskAppBinder
	UpdateGardenTaskAppRoute          *app_routes.UpdateGardenTaskAppRoute
	UpdateGardenTaskFormMolder        *molders.UpdateGardenTaskFormMolder
	UpdateGardenTaskFormPresenter     *form_presenters.UpdateGardenTaskFormPresenter
	UpdateGardenTaskFormValidator     *form_validators.UpdateGardenTaskFormValidator
	UpdateGardenTaskJsonView          *json_views.UpdateGardenTaskJsonView
	UpdateGardenTaskMae               *mae.UpdateGardenTaskMae
	UpdatePlantApiRoute               *api_routes.UpdatePlantApiRoute
	UpdatePlantAppBinder              *binders.UpdatePlantAppBinder
	UpdatePlantAppRoute               *app_routes.UpdatePlantAppRoute
	UpdatePlantFormMolder             *molders.UpdatePlantFormMolder
	UpdatePlantFormPresenter          *form_presenters.UpdatePlantFormPresenter
	UpdatePlantFormValidator          *form_validators.UpdatePlantFormValidator
	UpdatePlantJsonView               *json_views.UpdatePlantJsonView
	UpdatePlantMae                    *mae.UpdatePlantMae
	UpdatePlantTaskApiRoute           *api_routes.UpdatePlantTaskApiRoute
	UpdatePlantTaskAppBinder          *binders.UpdatePlantTaskAppBinder
	UpdatePlantTaskAppRoute           *app_routes.UpdatePlantTaskAppRoute
	UpdatePlantTaskFormMolder         *molders.UpdatePlantTaskFormMolder
	UpdatePlantTaskFormPresenter      *form_presenters.UpdatePlantTaskFormPresenter
	UpdatePlantTaskFormValidator      *form_validators.UpdatePlantTaskFormValidator
	UpdatePlantTaskJsonView           *json_views.UpdatePlantTaskJsonView
	UpdatePlantTaskMae                *mae.UpdatePlantTaskMae
	UpdatePlantationApiRoute          *api_routes.UpdatePlantationApiRoute
	UpdatePlantationAppBinder         *binders.UpdatePlantationAppBinder
	UpdatePlantationAppRoute          *app_routes.UpdatePlantationAppRoute
	UpdatePlantationFormMolder        *molders.UpdatePlantationFormMolder
	UpdatePlantationFormPresenter     *form_presenters.UpdatePlantationFormPresenter
	UpdatePlantationFormValidator     *form_validators.UpdatePlantationFormValidator
	UpdatePlantationJsonView          *json_views.UpdatePlantationJsonView
	UpdatePlantationMae               *mae.UpdatePlantationMae
	UpdateSeedProgramApiRoute         *api_routes.UpdateSeedProgramApiRoute
	UpdateSeedProgramAppBinder        *binders.UpdateSeedProgramAppBinder
	UpdateSeedProgramAppRoute         *app_routes.UpdateSeedProgramAppRoute
	UpdateSeedProgramFormMolder       *molders.UpdateSeedProgramFormMolder
	UpdateSeedProgramFormPresenter    *form_presenters.UpdateSeedProgramFormPresenter
	UpdateSeedProgramFormValidator    *form_validators.UpdateSeedProgramFormValidator
	UpdateSeedProgramJsonView         *json_views.UpdateSeedProgramJsonView
	UpdateSeedProgramMae              *mae.UpdateSeedProgramMae
	UpdateUserApiRoute                *api_routes.UpdateUserApiRoute
	UpdateUserAppBinder               *binders.UpdateUserAppBinder
	UpdateUserAppRoute                *app_routes.UpdateUserAppRoute
	UpdateUserFormMolder              *molders.UpdateUserFormMolder
	UpdateUserFormPresenter           *form_presenters.UpdateUserFormPresenter
	UpdateUserFormValidator           *form_validators.UpdateUserFormValidator
	UpdateUserJsonView                *json_views.UpdateUserJsonView
	UpdateUserMae                     *mae.UpdateUserMae
	UserCompanion                     *companions.UserCompanion
	UserCompleter                     *completers.UserCompleter
	UserEntityPolicy                  *entity_policies.UserEntityPolicy
	UserEntityValidator               *entity_validators.UserEntityValidator
	UserFetcher                       *fetchers.UserFetcher
	UserHandler                       *handlers.UserHandler
	UserHydrator                      *hydrators.UserHydrator
	UserPresenter                     *presenters.UserPresenter
	UserRelationer                    *relationers.UserRelationer
	UserSearcher                      *searchers.UserSearcher
	UserSerializer                    *serializers.UserSerializer
	UserShowPresenter                 *show_presenters.UserShowPresenter
	UserStringer                      *stringers.UserStringer
	UserTable                         *tables.UserTable
	Uuider                            *uuider.Uuider
	Validator                         *validator.Validator
	VerticalLayout                    *layouts.VerticalLayout
	WebCommand                        *commands.WebCommand
	WebServer                         *web_server.WebServer
}

func (this *Container) Self() {
}
