package container

import (
	"gitlab.com/ccyrillee/kitcla"
)

func (this *Container) BuildContainer(env string) {
	skipInjections := []string{"Kit"}

	this.ConstructContainer()
	this.constructionCustomization(env)
	this.InjectContainer(skipInjections)
}

func (this *Container) constructionCustomization(env string) {
	this.Kit.Kit = *kitcla.New()
	this.buildInterfaces(env)
}

func (this *Container) buildInterfaces(env string) {
	this.buildOperatingSystemInterface(env)
	this.buildSqlInterface(env)
	this.buildSecondarySqlInterface(env)
	this.buildTimeInterface(env)
}

func (this *Container) buildOperatingSystemInterface(env string) {
	if this.OperatingSystemInterface != nil {
		return
	}
	this.OperatingSystemInterface = this.OperatingSystemIpl
}

func (this *Container) buildSqlInterface(env string) {
	if this.Sql != nil {
		return
	}
	this.Sql = this.SqliteFsSqlIpl
}

func (this *Container) buildSecondarySqlInterface(env string) {
	if this.SecondarySql != nil {
		return
	}
	this.SecondarySql = this.PgSqlIpl
}

func (this *Container) buildTimeInterface(env string) {
	if this.Time != nil {
		return
	}
	this.Time = this.TimeIpl
}

func (this *Container) buildExecInterface(env string) {
	if this.ExecInterface != nil {
		return
	}
	this.ExecInterface = this.ExecIpl
}
