package routers

// |@@| C

import (
	"context"
	ajx_routes "gardening/src/app/routing/ajx_routes"
	"gardening/src/lib/middlewares"
	"github.com/gin-gonic/gin"
)

type AjxRouter struct {
	AutocompleteAjxRoute *ajx_routes.AutocompleteAjxRoute
	JwtMiddleware        *middlewares.JwtMiddleware
	SearchAjxRoute       *ajx_routes.SearchAjxRoute
}

func (this *AjxRouter) Act(ctx context.Context, r *gin.Engine) {
	router := r.Group("/ajx")
	router.Use(this.JwtMiddleware.Act())
	this.configureRoutes(router)
}
func (this *AjxRouter) configureRoutes(router *gin.RouterGroup) {
	router.POST("autocomplete", this.AutocompleteAjxRoute.Act)
	router.POST("search", this.SearchAjxRoute.Act)
}
