package routers

// |@@| C

import (
	"context"
	api_routes "gardening/src/app/routing/api_routes"
	"github.com/gin-gonic/gin"
)

type ApiRouter struct {
	CreateGardenApiRoute      *api_routes.CreateGardenApiRoute
	CreateGardenTaskApiRoute  *api_routes.CreateGardenTaskApiRoute
	CreatePlantApiRoute       *api_routes.CreatePlantApiRoute
	CreatePlantTaskApiRoute   *api_routes.CreatePlantTaskApiRoute
	CreatePlantationApiRoute  *api_routes.CreatePlantationApiRoute
	CreateSeedProgramApiRoute *api_routes.CreateSeedProgramApiRoute
	CreateUserApiRoute        *api_routes.CreateUserApiRoute
	ListGardenTasksApiRoute   *api_routes.ListGardenTasksApiRoute
	ListGardensApiRoute       *api_routes.ListGardensApiRoute
	ListPlantTasksApiRoute    *api_routes.ListPlantTasksApiRoute
	ListPlantationsApiRoute   *api_routes.ListPlantationsApiRoute
	ListPlantsApiRoute        *api_routes.ListPlantsApiRoute
	ListSeedProgramsApiRoute  *api_routes.ListSeedProgramsApiRoute
	ListUsersApiRoute         *api_routes.ListUsersApiRoute
	UpdateGardenApiRoute      *api_routes.UpdateGardenApiRoute
	UpdateGardenTaskApiRoute  *api_routes.UpdateGardenTaskApiRoute
	UpdatePlantApiRoute       *api_routes.UpdatePlantApiRoute
	UpdatePlantTaskApiRoute   *api_routes.UpdatePlantTaskApiRoute
	UpdatePlantationApiRoute  *api_routes.UpdatePlantationApiRoute
	UpdateSeedProgramApiRoute *api_routes.UpdateSeedProgramApiRoute
	UpdateUserApiRoute        *api_routes.UpdateUserApiRoute
}

func (this *ApiRouter) Act(ctx context.Context, r *gin.Engine) {
	router := r.Group("/api/v1")
	this.configureRoutes(router)
}
func (this *ApiRouter) configureRoutes(router *gin.RouterGroup) {
	router.POST("create-garden", this.CreateGardenApiRoute.Act)
	router.POST("create-garden-task", this.CreateGardenTaskApiRoute.Act)
	router.POST("create-plant", this.CreatePlantApiRoute.Act)
	router.POST("create-plant-task", this.CreatePlantTaskApiRoute.Act)
	router.POST("create-plantation", this.CreatePlantationApiRoute.Act)
	router.POST("create-seed-program", this.CreateSeedProgramApiRoute.Act)
	router.POST("create-user", this.CreateUserApiRoute.Act)
	router.POST("list-garden-tasks", this.ListGardenTasksApiRoute.Act)
	router.POST("list-gardens", this.ListGardensApiRoute.Act)
	router.POST("list-plant-tasks", this.ListPlantTasksApiRoute.Act)
	router.POST("list-plantations", this.ListPlantationsApiRoute.Act)
	router.POST("list-plants", this.ListPlantsApiRoute.Act)
	router.POST("list-seed-programs", this.ListSeedProgramsApiRoute.Act)
	router.POST("list-users", this.ListUsersApiRoute.Act)
	router.POST("update-garden", this.UpdateGardenApiRoute.Act)
	router.POST("update-garden-task", this.UpdateGardenTaskApiRoute.Act)
	router.POST("update-plant", this.UpdatePlantApiRoute.Act)
	router.POST("update-plant-task", this.UpdatePlantTaskApiRoute.Act)
	router.POST("update-plantation", this.UpdatePlantationApiRoute.Act)
	router.POST("update-seed-program", this.UpdateSeedProgramApiRoute.Act)
	router.POST("update-user", this.UpdateUserApiRoute.Act)
}
