package routers

// |@@| C

import (
	"context"
	app_routes "gardening/src/app/routing/app_routes"
	"gardening/src/lib/middlewares"
	"gardening/src/lib/router"
	"github.com/gin-gonic/gin"
)

type AppRouter struct {
	CreateGardenAppRoute           *app_routes.CreateGardenAppRoute
	CreateGardenTaskAppRoute       *app_routes.CreateGardenTaskAppRoute
	CreatePlantAppRoute            *app_routes.CreatePlantAppRoute
	CreatePlantTaskAppRoute        *app_routes.CreatePlantTaskAppRoute
	CreatePlantationAppRoute       *app_routes.CreatePlantationAppRoute
	CreateSeedProgramAppRoute      *app_routes.CreateSeedProgramAppRoute
	CreateUserAppRoute             *app_routes.CreateUserAppRoute
	DeleteGardenAppRoute           *app_routes.DeleteGardenAppRoute
	DeleteGardenTaskAppRoute       *app_routes.DeleteGardenTaskAppRoute
	DeletePlantAppRoute            *app_routes.DeletePlantAppRoute
	DeletePlantTaskAppRoute        *app_routes.DeletePlantTaskAppRoute
	DeletePlantationAppRoute       *app_routes.DeletePlantationAppRoute
	DeleteSeedProgramAppRoute      *app_routes.DeleteSeedProgramAppRoute
	DeleteUserAppRoute             *app_routes.DeleteUserAppRoute
	DisplayWeatherForecastAppRoute *app_routes.DisplayWeatherForecastAppRoute
	EditGardenAppRoute             *app_routes.EditGardenAppRoute
	EditGardenTaskAppRoute         *app_routes.EditGardenTaskAppRoute
	EditPlantAppRoute              *app_routes.EditPlantAppRoute
	EditPlantTaskAppRoute          *app_routes.EditPlantTaskAppRoute
	EditPlantationAppRoute         *app_routes.EditPlantationAppRoute
	EditSeedProgramAppRoute        *app_routes.EditSeedProgramAppRoute
	EditUserAppRoute               *app_routes.EditUserAppRoute
	HomeAppRoute                   *app_routes.HomeAppRoute
	InstructPlannerAppRoute        *app_routes.InstructPlannerAppRoute
	JwtMiddleware                  *middlewares.JwtMiddleware
	ListGardenTasksAppRoute        *app_routes.ListGardenTasksAppRoute
	ListGardensAppRoute            *app_routes.ListGardensAppRoute
	ListPlantTasksAppRoute         *app_routes.ListPlantTasksAppRoute
	ListPlantationsAppRoute        *app_routes.ListPlantationsAppRoute
	ListPlantsAppRoute             *app_routes.ListPlantsAppRoute
	ListSeedProgramsAppRoute       *app_routes.ListSeedProgramsAppRoute
	ListUsersAppRoute              *app_routes.ListUsersAppRoute
	NewGardenAppRoute              *app_routes.NewGardenAppRoute
	NewGardenTaskAppRoute          *app_routes.NewGardenTaskAppRoute
	NewPlantAppRoute               *app_routes.NewPlantAppRoute
	NewPlantTaskAppRoute           *app_routes.NewPlantTaskAppRoute
	NewPlantationAppRoute          *app_routes.NewPlantationAppRoute
	NewSeedProgramAppRoute         *app_routes.NewSeedProgramAppRoute
	NewUserAppRoute                *app_routes.NewUserAppRoute
	OverviewStorageAppRoute        *app_routes.OverviewStorageAppRoute
	PerformAnalyseAppRoute         *app_routes.PerformAnalyseAppRoute
	PerformImagesRoutineAppRoute   *app_routes.PerformImagesRoutineAppRoute
	PerformRenewOrdersAppRoute     *app_routes.PerformRenewOrdersAppRoute
	Router                         *router.Router
	SeeEventsAppRoute              *app_routes.SeeEventsAppRoute
	SeePlannerAppRoute             *app_routes.SeePlannerAppRoute
	SeeRenewOrdersAppRoute         *app_routes.SeeRenewOrdersAppRoute
	ShowGardenAppRoute             *app_routes.ShowGardenAppRoute
	ShowGardenTaskAppRoute         *app_routes.ShowGardenTaskAppRoute
	ShowPlantAppRoute              *app_routes.ShowPlantAppRoute
	ShowPlantTaskAppRoute          *app_routes.ShowPlantTaskAppRoute
	ShowPlantationAppRoute         *app_routes.ShowPlantationAppRoute
	ShowSeedProgramAppRoute        *app_routes.ShowSeedProgramAppRoute
	ShowUserAppRoute               *app_routes.ShowUserAppRoute
	UpdateGardenAppRoute           *app_routes.UpdateGardenAppRoute
	UpdateGardenTaskAppRoute       *app_routes.UpdateGardenTaskAppRoute
	UpdatePlantAppRoute            *app_routes.UpdatePlantAppRoute
	UpdatePlantTaskAppRoute        *app_routes.UpdatePlantTaskAppRoute
	UpdatePlantationAppRoute       *app_routes.UpdatePlantationAppRoute
	UpdateSeedProgramAppRoute      *app_routes.UpdateSeedProgramAppRoute
	UpdateUserAppRoute             *app_routes.UpdateUserAppRoute
}

func (this *AppRouter) Act(ctx context.Context, r *gin.Engine) {
	router := r.Group("/app")
	router.Use(this.JwtMiddleware.Act())
	this.configureRoutes(router)
}
func (this *AppRouter) configureRoutes(router *gin.RouterGroup) {
	this.Router.AddRoute(router, this.CreateGardenAppRoute)
	this.Router.AddRoute(router, this.CreateGardenTaskAppRoute)
	this.Router.AddRoute(router, this.CreatePlantAppRoute)
	this.Router.AddRoute(router, this.CreatePlantTaskAppRoute)
	this.Router.AddRoute(router, this.CreatePlantationAppRoute)
	this.Router.AddRoute(router, this.CreateSeedProgramAppRoute)
	this.Router.AddRoute(router, this.CreateUserAppRoute)
	this.Router.AddRoute(router, this.DeleteGardenAppRoute)
	this.Router.AddRoute(router, this.DeleteGardenTaskAppRoute)
	this.Router.AddRoute(router, this.DeletePlantAppRoute)
	this.Router.AddRoute(router, this.DeletePlantTaskAppRoute)
	this.Router.AddRoute(router, this.DeletePlantationAppRoute)
	this.Router.AddRoute(router, this.DeleteSeedProgramAppRoute)
	this.Router.AddRoute(router, this.DeleteUserAppRoute)
	this.Router.AddRoute(router, this.DisplayWeatherForecastAppRoute)
	this.Router.AddRoute(router, this.EditGardenAppRoute)
	this.Router.AddRoute(router, this.EditGardenTaskAppRoute)
	this.Router.AddRoute(router, this.EditPlantAppRoute)
	this.Router.AddRoute(router, this.EditPlantTaskAppRoute)
	this.Router.AddRoute(router, this.EditPlantationAppRoute)
	this.Router.AddRoute(router, this.EditSeedProgramAppRoute)
	this.Router.AddRoute(router, this.EditUserAppRoute)
	this.Router.AddRoute(router, this.HomeAppRoute)
	this.Router.AddRoute(router, this.InstructPlannerAppRoute)
	this.Router.AddRoute(router, this.ListGardenTasksAppRoute)
	this.Router.AddRoute(router, this.ListGardensAppRoute)
	this.Router.AddRoute(router, this.ListPlantTasksAppRoute)
	this.Router.AddRoute(router, this.ListPlantationsAppRoute)
	this.Router.AddRoute(router, this.ListPlantsAppRoute)
	this.Router.AddRoute(router, this.ListSeedProgramsAppRoute)
	this.Router.AddRoute(router, this.ListUsersAppRoute)
	this.Router.AddRoute(router, this.NewGardenAppRoute)
	this.Router.AddRoute(router, this.NewGardenTaskAppRoute)
	this.Router.AddRoute(router, this.NewPlantAppRoute)
	this.Router.AddRoute(router, this.NewPlantTaskAppRoute)
	this.Router.AddRoute(router, this.NewPlantationAppRoute)
	this.Router.AddRoute(router, this.NewSeedProgramAppRoute)
	this.Router.AddRoute(router, this.NewUserAppRoute)
	this.Router.AddRoute(router, this.OverviewStorageAppRoute)
	this.Router.AddRoute(router, this.PerformAnalyseAppRoute)
	this.Router.AddRoute(router, this.PerformImagesRoutineAppRoute)
	this.Router.AddRoute(router, this.PerformRenewOrdersAppRoute)
	this.Router.AddRoute(router, this.SeeEventsAppRoute)
	this.Router.AddRoute(router, this.SeePlannerAppRoute)
	this.Router.AddRoute(router, this.SeeRenewOrdersAppRoute)
	this.Router.AddRoute(router, this.ShowGardenAppRoute)
	this.Router.AddRoute(router, this.ShowGardenTaskAppRoute)
	this.Router.AddRoute(router, this.ShowPlantAppRoute)
	this.Router.AddRoute(router, this.ShowPlantTaskAppRoute)
	this.Router.AddRoute(router, this.ShowPlantationAppRoute)
	this.Router.AddRoute(router, this.ShowSeedProgramAppRoute)
	this.Router.AddRoute(router, this.ShowUserAppRoute)
	this.Router.AddRoute(router, this.UpdateGardenAppRoute)
	this.Router.AddRoute(router, this.UpdateGardenTaskAppRoute)
	this.Router.AddRoute(router, this.UpdatePlantAppRoute)
	this.Router.AddRoute(router, this.UpdatePlantTaskAppRoute)
	this.Router.AddRoute(router, this.UpdatePlantationAppRoute)
	this.Router.AddRoute(router, this.UpdateSeedProgramAppRoute)
	this.Router.AddRoute(router, this.UpdateUserAppRoute)
}
