package routers

// |@@| C

import (
	"context"
	routes "gardening/src/app/routing/misc_routes"
	"gardening/src/lib/middlewares"
	"github.com/gin-gonic/gin"
)

type AuthRouter struct {
	JwtMiddleware     *middlewares.JwtMiddleware
	AppLoginMiscRoute *routes.AppLoginMiscRoute
}

func (this *AuthRouter) Act(ctx context.Context, r *gin.Engine) {
	auth := r.Group("/auth")
	auth.GET("/refresh_token", this.JwtMiddleware.RefreshRoute())
	auth.POST("/login", this.JwtMiddleware.LoginRoute())
	auth.GET("/logout", this.JwtMiddleware.LogoutRoute())
	auth.GET("/app-login", this.AppLoginMiscRoute.Act)
}
