package routers

// |@@| C

import (
	"context"
	misc_routes "gardening/src/app/routing/misc_routes"
	"gardening/src/lib/config"
	"gardening/src/lib/kit"
	"gardening/src/lib/logger"
	"gardening/src/lib/route"
	"gardening/src/srv/layouts"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type MiscRouter struct {
	Kit                *kit.Kit
	Config             *config.Config
	AppUrler           *urlers.AppUrler
	AppRoute           *route.AppRoute
	EmptyLayout        *layouts.EmptyLayout
	Logger             *logger.Logger
	PingMiscRoute      *misc_routes.PingMiscRoute
	OpenapiMiscRoute   *misc_routes.OpenapiMiscRoute
	RootMiscRoute      *misc_routes.RootMiscRoute
	FollowOpMiscRoute  *misc_routes.FollowOpMiscRoute
	DisplayOpMiscRoute *misc_routes.DisplayOpMiscRoute
}

func (this *MiscRouter) Act(ctx context.Context, r *gin.Engine) {
	this.configureRoutes(r)
	this.configureAssetsRoutes(r)
}

func (this *MiscRouter) configureRoutes(r *gin.Engine) {
	r.GET("/", this.RootMiscRoute.Act)
	r.GET("/ping", this.PingMiscRoute.Act)
	r.GET("/openapi.json", this.OpenapiMiscRoute.Act)
	r.GET("/follow-op", this.FollowOpMiscRoute.Act)
	r.GET("/display-op", this.DisplayOpMiscRoute.Act)
}

func (this *MiscRouter) configureAssetsRoutes(r *gin.Engine) {
	assets := r.Group("")
	assets.Use(func(c *gin.Context) {
		c.Header("Cache-Control", "max-age=604800")
		c.Next()
	})
	assets.Static("/assets", this.Config.GetRootDir()+"/assets")
	assets.Static("/assets-kit", this.Config.GetRootDir()+"/assets")
}
