package routes

// |@@| C

import (
	"gardening/src/lib"
	"gardening/src/srv/autocompleters"
	"github.com/gin-gonic/gin"
)

type AutocompleteAjxRoute struct {
	Autocompleter *autocompleters.Autocompleter
}

func (this *AutocompleteAjxRoute) Act(c *gin.Context) {
	req := this.Autocompleter.NewRequest()
	err := c.BindJSON(req)
	lib.Poe(err)

	items, err := this.Autocompleter.Provide(c, req)
	if err != nil {
		panic(err)
	}
	c.JSON(200, gin.H{"items": items})
}
