package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type CreateGardenApiRoute struct {
	ApiRoute             *route.ApiRoute
	CreateGardenJsonView *json_views.CreateGardenJsonView
	CreateGardenMae      *mae.CreateGardenMae
}

func (this *CreateGardenApiRoute) Act(c *gin.Context) {
	in := &maes.CreateGardenMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.CreateGardenMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.CreateGardenJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
