package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type CreateGardenTaskApiRoute struct {
	ApiRoute                 *route.ApiRoute
	CreateGardenTaskJsonView *json_views.CreateGardenTaskJsonView
	CreateGardenTaskMae      *mae.CreateGardenTaskMae
}

func (this *CreateGardenTaskApiRoute) Act(c *gin.Context) {
	in := &maes.CreateGardenTaskMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.CreateGardenTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.CreateGardenTaskJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
