package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type CreatePlantApiRoute struct {
	ApiRoute            *route.ApiRoute
	CreatePlantJsonView *json_views.CreatePlantJsonView
	CreatePlantMae      *mae.CreatePlantMae
}

func (this *CreatePlantApiRoute) Act(c *gin.Context) {
	in := &maes.CreatePlantMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.CreatePlantMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.CreatePlantJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
