package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type CreatePlantTaskApiRoute struct {
	ApiRoute                *route.ApiRoute
	CreatePlantTaskJsonView *json_views.CreatePlantTaskJsonView
	CreatePlantTaskMae      *mae.CreatePlantTaskMae
}

func (this *CreatePlantTaskApiRoute) Act(c *gin.Context) {
	in := &maes.CreatePlantTaskMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.CreatePlantTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.CreatePlantTaskJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
