package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type CreatePlantationApiRoute struct {
	ApiRoute                 *route.ApiRoute
	CreatePlantationJsonView *json_views.CreatePlantationJsonView
	CreatePlantationMae      *mae.CreatePlantationMae
}

func (this *CreatePlantationApiRoute) Act(c *gin.Context) {
	in := &maes.CreatePlantationMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.CreatePlantationMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.CreatePlantationJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
