package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type CreateSeedProgramApiRoute struct {
	ApiRoute                  *route.ApiRoute
	CreateSeedProgramJsonView *json_views.CreateSeedProgramJsonView
	CreateSeedProgramMae      *mae.CreateSeedProgramMae
}

func (this *CreateSeedProgramApiRoute) Act(c *gin.Context) {
	in := &maes.CreateSeedProgramMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.CreateSeedProgramMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.CreateSeedProgramJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
