package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type CreateUserApiRoute struct {
	ApiRoute           *route.ApiRoute
	CreateUserJsonView *json_views.CreateUserJsonView
	CreateUserMae      *mae.CreateUserMae
}

func (this *CreateUserApiRoute) Act(c *gin.Context) {
	in := &maes.CreateUserMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.CreateUserMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.CreateUserJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
