package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type ListGardenTasksApiRoute struct {
	ApiRoute                *route.ApiRoute
	ListGardenTasksJsonView *json_views.ListGardenTasksJsonView
	ListGardenTasksMae      *mae.ListGardenTasksMae
}

func (this *ListGardenTasksApiRoute) Act(c *gin.Context) {
	in := &maes.ListGardenTasksMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request)
	if err != nil {
		c.AbortWithError(401, err)
		return
	}
	out, errMae := this.ListGardenTasksMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.ListGardenTasksJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
