package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type ListGardensApiRoute struct {
	ApiRoute            *route.ApiRoute
	ListGardensJsonView *json_views.ListGardensJsonView
	ListGardensMae      *mae.ListGardensMae
}

func (this *ListGardensApiRoute) Act(c *gin.Context) {
	in := &maes.ListGardensMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request)
	if err != nil {
		c.AbortWithError(401, err)
		return
	}
	out, errMae := this.ListGardensMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.ListGardensJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
