package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type ListPlantTasksApiRoute struct {
	ApiRoute               *route.ApiRoute
	ListPlantTasksJsonView *json_views.ListPlantTasksJsonView
	ListPlantTasksMae      *mae.ListPlantTasksMae
}

func (this *ListPlantTasksApiRoute) Act(c *gin.Context) {
	in := &maes.ListPlantTasksMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request)
	if err != nil {
		c.AbortWithError(401, err)
		return
	}
	out, errMae := this.ListPlantTasksMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.ListPlantTasksJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
