package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type ListPlantationsApiRoute struct {
	ApiRoute                *route.ApiRoute
	ListPlantationsJsonView *json_views.ListPlantationsJsonView
	ListPlantationsMae      *mae.ListPlantationsMae
}

func (this *ListPlantationsApiRoute) Act(c *gin.Context) {
	in := &maes.ListPlantationsMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request)
	if err != nil {
		c.AbortWithError(401, err)
		return
	}
	out, errMae := this.ListPlantationsMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.ListPlantationsJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
