package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type ListSeedProgramsApiRoute struct {
	ApiRoute                 *route.ApiRoute
	ListSeedProgramsJsonView *json_views.ListSeedProgramsJsonView
	ListSeedProgramsMae      *mae.ListSeedProgramsMae
}

func (this *ListSeedProgramsApiRoute) Act(c *gin.Context) {
	in := &maes.ListSeedProgramsMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request)
	if err != nil {
		c.AbortWithError(401, err)
		return
	}
	out, errMae := this.ListSeedProgramsMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.ListSeedProgramsJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
