package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type ListUsersApiRoute struct {
	ApiRoute          *route.ApiRoute
	ListUsersJsonView *json_views.ListUsersJsonView
	ListUsersMae      *mae.ListUsersMae
}

func (this *ListUsersApiRoute) Act(c *gin.Context) {
	in := &maes.ListUsersMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request)
	if err != nil {
		c.AbortWithError(401, err)
		return
	}
	out, errMae := this.ListUsersMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.ListUsersJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
