package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type UpdateGardenApiRoute struct {
	ApiRoute             *route.ApiRoute
	UpdateGardenJsonView *json_views.UpdateGardenJsonView
	UpdateGardenMae      *mae.UpdateGardenMae
}

func (this *UpdateGardenApiRoute) Act(c *gin.Context) {
	in := &maes.UpdateGardenMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.UpdateGardenMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.UpdateGardenJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
