package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type UpdateGardenTaskApiRoute struct {
	ApiRoute                 *route.ApiRoute
	UpdateGardenTaskJsonView *json_views.UpdateGardenTaskJsonView
	UpdateGardenTaskMae      *mae.UpdateGardenTaskMae
}

func (this *UpdateGardenTaskApiRoute) Act(c *gin.Context) {
	in := &maes.UpdateGardenTaskMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.UpdateGardenTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.UpdateGardenTaskJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
