package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type UpdatePlantApiRoute struct {
	ApiRoute            *route.ApiRoute
	UpdatePlantJsonView *json_views.UpdatePlantJsonView
	UpdatePlantMae      *mae.UpdatePlantMae
}

func (this *UpdatePlantApiRoute) Act(c *gin.Context) {
	in := &maes.UpdatePlantMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.UpdatePlantMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.UpdatePlantJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
