package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type UpdatePlantTaskApiRoute struct {
	ApiRoute                *route.ApiRoute
	UpdatePlantTaskJsonView *json_views.UpdatePlantTaskJsonView
	UpdatePlantTaskMae      *mae.UpdatePlantTaskMae
}

func (this *UpdatePlantTaskApiRoute) Act(c *gin.Context) {
	in := &maes.UpdatePlantTaskMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.UpdatePlantTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.UpdatePlantTaskJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
