package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type UpdatePlantationApiRoute struct {
	ApiRoute                 *route.ApiRoute
	UpdatePlantationJsonView *json_views.UpdatePlantationJsonView
	UpdatePlantationMae      *mae.UpdatePlantationMae
}

func (this *UpdatePlantationApiRoute) Act(c *gin.Context) {
	in := &maes.UpdatePlantationMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.UpdatePlantationMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.UpdatePlantationJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
