package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type UpdateSeedProgramApiRoute struct {
	ApiRoute                  *route.ApiRoute
	UpdateSeedProgramJsonView *json_views.UpdateSeedProgramJsonView
	UpdateSeedProgramMae      *mae.UpdateSeedProgramMae
}

func (this *UpdateSeedProgramApiRoute) Act(c *gin.Context) {
	in := &maes.UpdateSeedProgramMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.UpdateSeedProgramMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.UpdateSeedProgramJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
