package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/json_views"
	"github.com/gin-gonic/gin"
)

type UpdateUserApiRoute struct {
	ApiRoute           *route.ApiRoute
	UpdateUserJsonView *json_views.UpdateUserJsonView
	UpdateUserMae      *mae.UpdateUserMae
}

func (this *UpdateUserApiRoute) Act(c *gin.Context) {
	in := &maes.UpdateUserMaeIn{}
	this.ApiRoute.PopulateInContext(c, &in.Context)
	err := c.BindJSON(&in.Request.Form)
	out, errMae := this.UpdateUserMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	json, err := this.UpdateUserJsonView.Json(out)
	if err != nil {
		panic(err)
	}
	c.Status(200)
	c.Writer.Write(json)
}
