package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreateGardenAppRoute struct {
	AppRoute              *route.AppRoute
	AppUrler              *urlers.AppUrler
	CreateGardenAppBinder *binders.CreateGardenAppBinder
	CreateGardenMae       *mae.CreateGardenMae
	NewGardenView         *html_views.NewGardenView
}

func (this *CreateGardenAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.CreateGardenMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.CreateGardenAppBinder.Bind(c, in, c)
	out, errMae := this.CreateGardenMae.Act(c, in)
	if errMae == nil {
		this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
		this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowGarden(out.Response.Garden.Id))
		return in, out
	}
	if this.AppRoute.CanRenderView(errMae) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.NewGardenView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	panic(errMae)
}
func (this *CreateGardenAppRoute) convertOut(out *maes.CreateGardenMaeOut) *maes.NewGardenMaeOut {
	return &maes.NewGardenMaeOut{
		In: &maes.NewGardenMaeIn{
			Request: maes.NewGardenMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.NewGardenMaeOutRes{
			Form:       out.In.Request.Form,
			FormBag:    out.Response.FormBag,
			FormFields: out.Response.FormFields,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *CreateGardenAppRoute) GetRoutePath() string {
	return "create-garden"
}
func (this *CreateGardenAppRoute) GetMethod() string {
	return "POST"
}
