package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreateGardenTaskAppRoute struct {
	AppRoute                  *route.AppRoute
	AppUrler                  *urlers.AppUrler
	CreateGardenTaskAppBinder *binders.CreateGardenTaskAppBinder
	CreateGardenTaskMae       *mae.CreateGardenTaskMae
	NewGardenTaskView         *html_views.NewGardenTaskView
}

func (this *CreateGardenTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.CreateGardenTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.CreateGardenTaskAppBinder.Bind(c, in, c)
	out, errMae := this.CreateGardenTaskMae.Act(c, in)
	if errMae == nil {
		this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
		this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowGardenTask(out.Response.GardenTask.Id))
		return in, out
	}
	if this.AppRoute.CanRenderView(errMae) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.NewGardenTaskView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	panic(errMae)
}
func (this *CreateGardenTaskAppRoute) convertOut(out *maes.CreateGardenTaskMaeOut) *maes.NewGardenTaskMaeOut {
	return &maes.NewGardenTaskMaeOut{
		In: &maes.NewGardenTaskMaeIn{
			Request: maes.NewGardenTaskMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.NewGardenTaskMaeOutRes{
			Form:       out.In.Request.Form,
			FormBag:    out.Response.FormBag,
			FormFields: out.Response.FormFields,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *CreateGardenTaskAppRoute) GetRoutePath() string {
	return "create-garden-task"
}
func (this *CreateGardenTaskAppRoute) GetMethod() string {
	return "POST"
}
