package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreatePlantAppRoute struct {
	AppRoute             *route.AppRoute
	AppUrler             *urlers.AppUrler
	CreatePlantAppBinder *binders.CreatePlantAppBinder
	CreatePlantMae       *mae.CreatePlantMae
	NewPlantView         *html_views.NewPlantView
}

func (this *CreatePlantAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.CreatePlantMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.CreatePlantAppBinder.Bind(c, in, c)
	out, errMae := this.CreatePlantMae.Act(c, in)
	if errMae == nil {
		this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
		this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowPlant(out.Response.Plant.Id))
		return in, out
	}
	if this.AppRoute.CanRenderView(errMae) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.NewPlantView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	panic(errMae)
}
func (this *CreatePlantAppRoute) convertOut(out *maes.CreatePlantMaeOut) *maes.NewPlantMaeOut {
	return &maes.NewPlantMaeOut{
		In: &maes.NewPlantMaeIn{
			Request: maes.NewPlantMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.NewPlantMaeOutRes{
			Form:       out.In.Request.Form,
			FormBag:    out.Response.FormBag,
			FormFields: out.Response.FormFields,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *CreatePlantAppRoute) GetRoutePath() string {
	return "create-plant"
}
func (this *CreatePlantAppRoute) GetMethod() string {
	return "POST"
}
