package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreatePlantTaskAppRoute struct {
	AppRoute                 *route.AppRoute
	AppUrler                 *urlers.AppUrler
	CreatePlantTaskAppBinder *binders.CreatePlantTaskAppBinder
	CreatePlantTaskMae       *mae.CreatePlantTaskMae
	NewPlantTaskView         *html_views.NewPlantTaskView
}

func (this *CreatePlantTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.CreatePlantTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.CreatePlantTaskAppBinder.Bind(c, in, c)
	out, errMae := this.CreatePlantTaskMae.Act(c, in)
	if errMae == nil {
		this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
		this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowPlantTask(out.Response.PlantTask.Id))
		return in, out
	}
	if this.AppRoute.CanRenderView(errMae) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.NewPlantTaskView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	panic(errMae)
}
func (this *CreatePlantTaskAppRoute) convertOut(out *maes.CreatePlantTaskMaeOut) *maes.NewPlantTaskMaeOut {
	return &maes.NewPlantTaskMaeOut{
		In: &maes.NewPlantTaskMaeIn{
			Request: maes.NewPlantTaskMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.NewPlantTaskMaeOutRes{
			Form:       out.In.Request.Form,
			FormBag:    out.Response.FormBag,
			FormFields: out.Response.FormFields,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *CreatePlantTaskAppRoute) GetRoutePath() string {
	return "create-plant-task"
}
func (this *CreatePlantTaskAppRoute) GetMethod() string {
	return "POST"
}
