package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreatePlantationAppRoute struct {
	AppRoute                  *route.AppRoute
	AppUrler                  *urlers.AppUrler
	CreatePlantationAppBinder *binders.CreatePlantationAppBinder
	CreatePlantationMae       *mae.CreatePlantationMae
	NewPlantationView         *html_views.NewPlantationView
}

func (this *CreatePlantationAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.CreatePlantationMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.CreatePlantationAppBinder.Bind(c, in, c)
	out, errMae := this.CreatePlantationMae.Act(c, in)
	if errMae == nil {
		this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
		this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowPlantation(out.Response.Plantation.Id))
		return in, out
	}
	if this.AppRoute.CanRenderView(errMae) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.NewPlantationView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	panic(errMae)
}
func (this *CreatePlantationAppRoute) convertOut(out *maes.CreatePlantationMaeOut) *maes.NewPlantationMaeOut {
	return &maes.NewPlantationMaeOut{
		In: &maes.NewPlantationMaeIn{
			Request: maes.NewPlantationMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.NewPlantationMaeOutRes{
			Form:       out.In.Request.Form,
			FormBag:    out.Response.FormBag,
			FormFields: out.Response.FormFields,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *CreatePlantationAppRoute) GetRoutePath() string {
	return "create-plantation"
}
func (this *CreatePlantationAppRoute) GetMethod() string {
	return "POST"
}
