package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreateSeedProgramAppRoute struct {
	AppRoute                   *route.AppRoute
	AppUrler                   *urlers.AppUrler
	CreateSeedProgramAppBinder *binders.CreateSeedProgramAppBinder
	CreateSeedProgramMae       *mae.CreateSeedProgramMae
	NewSeedProgramView         *html_views.NewSeedProgramView
}

func (this *CreateSeedProgramAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.CreateSeedProgramMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.CreateSeedProgramAppBinder.Bind(c, in, c)
	out, errMae := this.CreateSeedProgramMae.Act(c, in)
	if errMae == nil {
		this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
		this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowSeedProgram(out.Response.SeedProgram.Id))
		return in, out
	}
	if this.AppRoute.CanRenderView(errMae) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.NewSeedProgramView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	panic(errMae)
}
func (this *CreateSeedProgramAppRoute) convertOut(out *maes.CreateSeedProgramMaeOut) *maes.NewSeedProgramMaeOut {
	return &maes.NewSeedProgramMaeOut{
		In: &maes.NewSeedProgramMaeIn{
			Request: maes.NewSeedProgramMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.NewSeedProgramMaeOutRes{
			Form:       out.In.Request.Form,
			FormBag:    out.Response.FormBag,
			FormFields: out.Response.FormFields,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *CreateSeedProgramAppRoute) GetRoutePath() string {
	return "create-seed-program"
}
func (this *CreateSeedProgramAppRoute) GetMethod() string {
	return "POST"
}
