package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreateUserAppRoute struct {
	AppRoute            *route.AppRoute
	AppUrler            *urlers.AppUrler
	CreateUserAppBinder *binders.CreateUserAppBinder
	CreateUserMae       *mae.CreateUserMae
	NewUserView         *html_views.NewUserView
}

func (this *CreateUserAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.CreateUserMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.CreateUserAppBinder.Bind(c, in, c)
	out, errMae := this.CreateUserMae.Act(c, in)
	if errMae == nil {
		this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
		this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowUser(out.Response.User.Id))
		return in, out
	}
	if this.AppRoute.CanRenderView(errMae) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.NewUserView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	panic(errMae)
}
func (this *CreateUserAppRoute) convertOut(out *maes.CreateUserMaeOut) *maes.NewUserMaeOut {
	return &maes.NewUserMaeOut{
		In: &maes.NewUserMaeIn{
			Request: maes.NewUserMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.NewUserMaeOutRes{
			Form:       out.In.Request.Form,
			FormBag:    out.Response.FormBag,
			FormFields: out.Response.FormFields,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *CreateUserAppRoute) GetRoutePath() string {
	return "create-user"
}
func (this *CreateUserAppRoute) GetMethod() string {
	return "POST"
}
