package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type DeleteGardenAppRoute struct {
	AppRoute        *route.AppRoute
	AppUrler        *urlers.AppUrler
	DeleteGardenMae *mae.DeleteGardenMae
}

func (this *DeleteGardenAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.DeleteGardenMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.DeleteGardenMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	_ = out
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ListGardens())
	return in, out
}
func (this *DeleteGardenAppRoute) GetRoutePath() string {
	return "delete-garden"
}
func (this *DeleteGardenAppRoute) GetMethod() string {
	return "POST"
}
