package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type DeleteGardenTaskAppRoute struct {
	AppRoute            *route.AppRoute
	AppUrler            *urlers.AppUrler
	DeleteGardenTaskMae *mae.DeleteGardenTaskMae
}

func (this *DeleteGardenTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.DeleteGardenTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.DeleteGardenTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	_ = out
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ListGardenTasks())
	return in, out
}
func (this *DeleteGardenTaskAppRoute) GetRoutePath() string {
	return "delete-garden-task"
}
func (this *DeleteGardenTaskAppRoute) GetMethod() string {
	return "POST"
}
