package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type DeletePlantAppRoute struct {
	AppRoute       *route.AppRoute
	AppUrler       *urlers.AppUrler
	DeletePlantMae *mae.DeletePlantMae
}

func (this *DeletePlantAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.DeletePlantMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.DeletePlantMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	_ = out
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ListPlants())
	return in, out
}
func (this *DeletePlantAppRoute) GetRoutePath() string {
	return "delete-plant"
}
func (this *DeletePlantAppRoute) GetMethod() string {
	return "POST"
}
