package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type DeletePlantTaskAppRoute struct {
	AppRoute           *route.AppRoute
	AppUrler           *urlers.AppUrler
	DeletePlantTaskMae *mae.DeletePlantTaskMae
}

func (this *DeletePlantTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.DeletePlantTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.DeletePlantTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	_ = out
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ListPlantTasks())
	return in, out
}
func (this *DeletePlantTaskAppRoute) GetRoutePath() string {
	return "delete-plant-task"
}
func (this *DeletePlantTaskAppRoute) GetMethod() string {
	return "POST"
}
