package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type DeletePlantationAppRoute struct {
	AppRoute            *route.AppRoute
	AppUrler            *urlers.AppUrler
	DeletePlantationMae *mae.DeletePlantationMae
}

func (this *DeletePlantationAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.DeletePlantationMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.DeletePlantationMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	_ = out
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ListPlantations())
	return in, out
}
func (this *DeletePlantationAppRoute) GetRoutePath() string {
	return "delete-plantation"
}
func (this *DeletePlantationAppRoute) GetMethod() string {
	return "POST"
}
