package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type DeleteSeedProgramAppRoute struct {
	AppRoute             *route.AppRoute
	AppUrler             *urlers.AppUrler
	DeleteSeedProgramMae *mae.DeleteSeedProgramMae
}

func (this *DeleteSeedProgramAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.DeleteSeedProgramMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.DeleteSeedProgramMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	_ = out
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ListSeedPrograms())
	return in, out
}
func (this *DeleteSeedProgramAppRoute) GetRoutePath() string {
	return "delete-seed-program"
}
func (this *DeleteSeedProgramAppRoute) GetMethod() string {
	return "POST"
}
