package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type DeleteUserAppRoute struct {
	AppRoute      *route.AppRoute
	AppUrler      *urlers.AppUrler
	DeleteUserMae *mae.DeleteUserMae
}

func (this *DeleteUserAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.DeleteUserMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.DeleteUserMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	_ = out
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ListUsers())
	return in, out
}
func (this *DeleteUserAppRoute) GetRoutePath() string {
	return "delete-user"
}
func (this *DeleteUserAppRoute) GetMethod() string {
	return "POST"
}
